/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import meteordevelopment.meteorclient.events.render.ApplyTransformationEvent;
import meteordevelopment.meteorclient.events.render.RenderItemEntityEvent;
import meteordevelopment.meteorclient.mixininterface.IBakedQuad;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1087;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_804;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class ItemPhysics
extends Module {
    private static final class_2350[] FACES = new class_2350[]{null, class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039};
    private static final float PIXEL_SIZE = 0.0625f;
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> randomRotation;
    private final class_5819 random;
    private boolean renderingItem;

    public ItemPhysics() {
        super(Categories.Render, "item-physics", "Applies physics to items on the ground.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.randomRotation = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("random-rotation")).description("Adds a random rotation to every item.")).defaultValue(true)).build());
        this.random = class_5819.method_43053();
    }

    @EventHandler
    private void onRenderItemEntity(RenderItemEntityEvent event) {
        class_4587 matrices = event.matrixStack;
        matrices.method_22903();
        class_1799 itemStack = event.itemEntity.method_6983();
        class_1087 model = this.getModel(event.itemEntity);
        ModelInfo info = this.getInfo(model);
        this.random.method_43052((long)event.itemEntity.method_5628() * 2365798L);
        this.applyTransformation(matrices, model);
        matrices.method_46416(0.0f, info.offsetY, 0.0f);
        this.offsetInWater(matrices, event.itemEntity);
        this.preventZFighting(matrices, event.itemEntity);
        if (info.flat) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            matrices.method_46416(0.0f, 0.0f, info.offsetZ);
        }
        if (this.randomRotation.get().booleanValue()) {
            class_7833 axis = class_7833.field_40716;
            if (info.flat) {
                axis = class_7833.field_40718;
            }
            float degrees = (this.random.method_43057() * 2.0f - 1.0f) * 90.0f;
            matrices.method_22907(axis.rotationDegrees(degrees));
        }
        this.renderItem(event, matrices, itemStack, model, info);
        matrices.method_22909();
        event.cancel();
    }

    @EventHandler
    private void onApplyTransformation(ApplyTransformationEvent event) {
        if (this.renderingItem) {
            event.cancel();
        }
    }

    private void renderItem(RenderItemEntityEvent event, class_4587 matrices, class_1799 itemStack, class_1087 model, ModelInfo info) {
        this.renderingItem = true;
        int count = this.getRenderedCount(itemStack);
        for (int i = 0; i < count; ++i) {
            matrices.method_22903();
            if (i > 0) {
                float x = (this.random.method_43057() * 2.0f - 1.0f) * 0.25f;
                float z = (this.random.method_43057() * 2.0f - 1.0f) * 0.25f;
                this.translate(matrices, info, x, 0.0f, z);
            }
            event.itemRenderer.method_23179(itemStack, class_811.field_4318, false, matrices, event.vertexConsumerProvider, event.light, class_4608.field_21444, model);
            matrices.method_22909();
            float y = Math.max(this.random.method_43057() * 0.0625f, 0.03125f);
            this.translate(matrices, info, 0.0f, y, 0.0f);
        }
        this.renderingItem = false;
    }

    private void translate(class_4587 matrices, ModelInfo info, float x, float y, float z) {
        if (info.flat) {
            float temp = y;
            y = z;
            z = -temp;
        }
        matrices.method_46416(x, y, z);
    }

    private int getRenderedCount(class_1799 stack) {
        int i = 1;
        if (stack.method_7947() > 48) {
            i = 5;
        } else if (stack.method_7947() > 32) {
            i = 4;
        } else if (stack.method_7947() > 16) {
            i = 3;
        } else if (stack.method_7947() > 1) {
            i = 2;
        }
        return i;
    }

    private void applyTransformation(class_4587 matrices, class_1087 model) {
        class_804 transformation = model.method_4709().field_4303;
        float prevY = transformation.field_4286.y;
        transformation.field_4286.y = 0.0f;
        transformation.method_23075(false, matrices);
        transformation.field_4286.y = prevY;
    }

    private void offsetInWater(class_4587 matrices, class_1542 entity) {
        if (entity.method_5799()) {
            matrices.method_46416(0.0f, 0.333f, 0.0f);
        }
    }

    private void preventZFighting(class_4587 matrices, class_1542 entity) {
        float offset = 1.0E-4f;
        float distance = (float)this.mc.field_1773.method_19418().method_19326().method_1022(entity.method_19538());
        offset = Math.min(offset * Math.max(1.0f, distance), 0.01f);
        matrices.method_46416(0.0f, offset, 0.0f);
    }

    private class_1087 getModel(class_1542 entity) {
        class_1799 itemStack = entity.method_6983();
        if (itemStack.method_31574(class_1802.field_8547)) {
            return this.mc.method_1480().method_4012().method_3303().method_4742(class_918.field_40532);
        }
        if (itemStack.method_31574(class_1802.field_27070)) {
            return this.mc.method_1480().method_4012().method_3303().method_4742(class_918.field_40533);
        }
        return this.mc.method_1480().method_4019(itemStack, entity.method_37908(), null, entity.method_5628());
    }

    private ModelInfo getInfo(class_1087 model) {
        class_5819 random = class_5819.method_43053();
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (class_2350 face : FACES) {
            for (class_777 _quad : model.method_4707(null, face, random)) {
                IBakedQuad quad = (IBakedQuad)_quad;
                block10: for (int i = 0; i < 4; ++i) {
                    switch (_quad.method_3358()) {
                        case field_11033: {
                            minY = Math.min(minY, quad.meteor$getY(i));
                            continue block10;
                        }
                        case field_11036: {
                            maxY = Math.max(maxY, quad.meteor$getY(i));
                            continue block10;
                        }
                        case field_11043: {
                            minZ = Math.min(minZ, quad.meteor$getZ(i));
                            continue block10;
                        }
                        case field_11035: {
                            maxZ = Math.max(maxZ, quad.meteor$getZ(i));
                            continue block10;
                        }
                        case field_11039: {
                            minX = Math.min(minX, quad.meteor$getX(i));
                            continue block10;
                        }
                        case field_11034: {
                            maxX = Math.max(maxX, quad.meteor$getX(i));
                        }
                    }
                }
            }
        }
        if (minX == Float.MAX_VALUE) {
            minX = 0.0f;
        }
        if (minY == Float.MAX_VALUE) {
            minY = 0.0f;
        }
        if (minZ == Float.MAX_VALUE) {
            minZ = 0.0f;
        }
        if (maxX == Float.MIN_VALUE) {
            maxX = 1.0f;
        }
        if (maxY == Float.MIN_VALUE) {
            maxY = 1.0f;
        }
        if (maxZ == Float.MIN_VALUE) {
            maxZ = 1.0f;
        }
        float x = maxX - minX;
        float y = maxY - minY;
        float z = maxZ - minZ;
        boolean flat = x > 0.0625f && y > 0.0625f && z <= 0.0625f;
        return new ModelInfo(flat, 0.5f - minY, minZ - minY);
    }

    record ModelInfo(boolean flat, float offsetY, float offsetZ) {
    }
}

