/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.screens.settings;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WIntEdit;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.utils.misc.Names;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;

public class StatusEffectAmplifierMapSettingScreen
extends WindowScreen {
    private final Setting<Reference2IntMap<class_1291>> setting;
    private WTable table;
    private String filterText = "";

    public StatusEffectAmplifierMapSettingScreen(GuiTheme theme, Setting<Reference2IntMap<class_1291>> setting) {
        super(theme, "Modify Amplifiers");
        this.setting = setting;
    }

    @Override
    public void initWidgets() {
        WTextBox filter = this.add(this.theme.textBox("")).minWidth(400.0).expandX().widget();
        filter.setFocused(true);
        filter.action = () -> {
            this.filterText = filter.get().trim();
            this.table.clear();
            this.initTable();
        };
        this.table = this.add(this.theme.table()).expandX().widget();
        this.initTable();
    }

    private void initTable() {
        ArrayList<class_1291> statusEffects = new ArrayList<class_1291>((Collection<class_1291>)this.setting.get().keySet());
        statusEffects.sort(Comparator.comparing(Names::get));
        for (class_1291 statusEffect : statusEffects) {
            String name = Names.get(statusEffect);
            if (!StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)this.filterText)) continue;
            this.table.add(this.theme.itemWithLabel(this.getPotionStack(statusEffect), name)).expandCellX();
            WIntEdit level = this.theme.intEdit(this.setting.get().getInt((Object)statusEffect), 0, Integer.MAX_VALUE, true);
            level.action = () -> {
                this.setting.get().put((Object)statusEffect, level.get());
                this.setting.onChanged();
            };
            this.table.add(level).minWidth(50.0);
            this.table.row();
        }
    }

    private class_1799 getPotionStack(class_1291 effect) {
        class_1799 potion = class_1802.field_8574.method_7854();
        potion.method_57379(class_9334.field_49651, (Object)new class_1844(((class_1844)potion.method_57824(class_9334.field_49651)).comp_2378(), Optional.of(effect.method_5556()), ((class_1844)potion.method_57824(class_9334.field_49651)).comp_2380(), Optional.empty()));
        return potion;
    }
}

